;-----------------------------------------------------------------------------
; AutoIt Version: 3.2.2.0
; Author:Andrew Calcutt 	Last Edited:11/07/2007
; Script Function:	Runs Actions based on ini file
;-----------------------------------------------------------------------------
AutoItSetOption("RunErrorsFatal", 0) ;Do not show errors if run error
#include <GUIConstants.au3>
#include <GuiListView.au3>
#include <string.au3>
#include <File.au3>
#include <Array.au3>
#include <Process.au3>
#include <PrepSysFunc.au3> ;My Defined Functions for PrepSys
$objError = ObjEvent("AutoIt.Error", "_objErr")
; ----------------------------------------------------------------------------
Dim $settings = @HomeDrive & "\settings.ini"
Dim $scriptlocation = @HomeDrive & "\_no_gui.exe"
Dim $PrepsysLocation = IniRead($settings, "Program_Use_Only", "PrepsysLocation", "")
;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------
;Decalair Variables
Dim $shutdown
Dim $workingdir = IniRead($settings, "Script_Settings", "Working_Dir", "")
Dim $progressref = IniRead($settings, "Program_Use_Only", "Progress_Ref", "")
Dim $progressref2 = IniRead($settings, "Program_Use_Only", "Progress_Ref2", "")
Dim $logonuser1 = IniRead($settings, "Script_Settings", "Admin_Username", "")
Dim $logonpass1 = _StringEncrypt(0, IniRead($settings, "Script_Settings", "Admin_Password", ""), "Prepsys", 2)
Dim $logondomain1 = IniRead($settings, "Script_Settings", "Admin_Domain", @ComputerName)
Dim $logonuser2 = IniRead($settings, "Script_Settings", "Sysprep_Username", "")
Dim $logonpass2 = _StringEncrypt(0, IniRead($settings, "Script_Settings", "Sysprep_Password", ""), "Prepsys", 2)
Dim $logondomain2 = IniRead($settings, "Script_Settings", "Sysprep_Domain", @ComputerName)

Dim $defaultimgname = IniRead($settings, "Background", "Default_Image", "")
Dim $localimgname = IniRead($settings, "Background", "Local_Image", "")

Dim $mcafee_exe = IniRead($settings, "Program_Locations", "mcafee_exe", '"' & $workingdir & 'Extra\McAfee\AutoInstall_McAfee.exe"')
Dim $mcafee_patch_exe = IniRead($settings, "Program_Locations", "mcafee_patch_exe", '"' & $workingdir & 'Extra\McAfee\Patch\AutoInstall_McAfee_Patch.exe"')
Dim $sophos_exe = IniRead($settings, "Program_Locations", "sophos_exe", '"' & $workingdir & 'Extra\Sophos\AutoInstall_Sophos.exe"')
Dim $vpn_exe = IniRead($settings, "Program_Locations", "vpn_exe", '"' & $workingdir & 'Extra\VPN\AutoInstall_VPN.exe"')
Dim $office_exe = IniRead($settings, "Program_Locations", "office_exe", '"' & $workingdir & 'Extra\OFFICE\AutoInstall_Office.exe"')
Dim $datatel_exe = IniRead($settings, "Program_Locations", "datatel_exe", '"' & $workingdir & 'Extra\DATATEL\AutoInstall_Datatel.exe"')
Dim $deepfreeze_exe = IniRead($settings, "Program_Locations", "deepfreeze_exe", '"' & $workingdir & 'Extra\Deepfreeze\DFSeed.bat"')
Dim $cleansms_exe = IniRead($settings, "Program_Locations", "cleansms_exe", '"' & $workingdir & 'Extra\CleanSMS\AutoRun_cleansms.exe"')
Dim $wininstaller_exe = IniRead($settings, "Program_Locations", "wininstaller_exe", '"' & $workingdir & 'Extra\WindowsInstaller\WindowsInstaller-KB893803-v2-x86.exe" /passive /norestart')

Dim $netuser = IniRead($settings, "NetworkLogon", "NetAdmin", "")
Dim $netpass = _StringEncrypt(0, IniRead($settings, "NetworkLogon", "NetPass", ""), "Prepsys", 2)
Dim $netdom = IniRead($settings, "NetworkLogon", "NetDom", "")

Dim $toolbardir = IniRead($settings, "OFFICE", "OfficeToolbarDir", "C:\Documents and Settings\All Users\Start Menu\Programs\Microsoft Office")
Dim $machine_name = IniRead($settings, "JoinDomain", "MachineName", @ComputerName)
If IniRead($settings, "Program_Use_Only", "UseServiceTagAsName", 0) = 1 Then $machine_name = "D" & _GetServiceTagFromWMI ()
Dim $JDusername = IniRead($settings, "JoinDomain", "Username", "")
Dim $JDpassword = _StringEncrypt(0, IniRead($settings, "JoinDomain", "Password", ""), "Prepsys", 2)

Dim $JDdomain = IniRead($settings, "JoinDomain", "Domain", "")
Dim $jointo = IniRead($settings, "JoinDomain", "OUdefault", "")
Dim $JDou = IniRead($settings, "Join_Domain_OU", $jointo, "")
Dim $JDcomputerdomain = IniRead($settings, "Join_Domain", $jointo, "")

Dim $HKUS1521 = 'HKEY_CURRENT_USER' ; $HKUS1521 = "HKEY_USERS\" & _FindReg ("HKEY_USERS", "S-1-5-21", "_Classes")
;-----------------------------------------------------------------------------
;Auto Logon Remove
_Logon ("REMOVE")
;-----------------------------------------------------------------------------
GUICreate("PrepSys Progress", 200, 50, (@DesktopWidth - 200) , (0))

$action_progress = GUICtrlCreateProgress(10, 2, 180, 12)
$current_action = GUICtrlCreateLabel("", 13, 28, 315, 23)

GUISetState()
While 1
	$msg = GUIGetMsg()
	Select
		Case $msg = $GUI_EVENT_CLOSE
			ExitLoop
	EndSelect
	
	;*** COPY USERNAME OF INITIAL XP USER(IF NOT DEFAULT ADMIN ACCOUNT) ***
	If IniRead($settings, "Script_Settings", "Delete_Start_User", "0") = 1 And IniRead($settings, "Program_Use_Only", "Delete_Start_User_Step1", "0") = 0 Then
		If @UserName <> $logonuser1 Then
			GUICtrlSetData($current_action, "Deleting Initial User")
			IniWrite($settings, "Script_Settings", "Delete_User", @UserName)
			IniWrite($settings, "Program_Use_Only", "Delete_Start_User_Step1", "1")
			IniWrite($settings, "Program_Use_Only", "Delete_Start_User_Step2", "0")
			_Shutdown ("REBOOT", "ADD", $logonuser1, $logonpass1, $logondomain1, $scriptlocation)
		Else
			IniWrite($settings, "Program_Use_Only", "Delete_Start_User_Step1", "1")
			IniWrite($settings, "Program_Use_Only", "Delete_Start_User_Step2", "1")
			_Progress_Ref ("ADD")
		EndIf
	EndIf
	
	_Progress_Ref ("SHOW")
	
	;*** DELETE INITIAL USER ***
	If IniRead($settings, "Script_Settings", "Delete_Start_User", "0") = 1 And IniRead($settings, "Program_Use_Only", "Delete_Start_User_Step2", "0") = 0 Then
		GUICtrlSetData($current_action, "Deleting Initial User")
		_User ("REMOVE", IniRead($settings, "Script_Settings", "Delete_User", ""))
		IniWrite($settings, "Program_Use_Only", "Delete_Start_User_Step2", "1")
		_Progress_Ref ("ADD")
	EndIf
	
	_Progress_Ref ("SHOW")
	
	;*** JOIN DOMAIN ***
	If IniRead($settings, "Script_Settings", "Join_To_Domain", "0") = 1 And IniRead($settings, "Program_Use_Only", "Joined_To_Domain", "0") = 0 Then
		If @ComputerName <> $machine_name Then
			GUICtrlSetData($current_action, "Changing Computer Name")
			_ChangeComputerName ($machine_name, $logonuser1, $logonpass1, $logondomain1, $scriptlocation);If the current computer name does not match the specified name then change the computer name
		EndIf
		GUICtrlSetData($current_action, "Joining Computer to Domain")
		$JD = _JoinToDomain ($JDdomain, $JDusername, $JDpassword, $machine_name, $JDcomputerdomain, $JDou)
		_Progress_Ref ("ADD")
		IniWrite($settings, "Program_Use_Only", "Joined_To_Domain", "1")
		If $JD = 1 Then
			If IniRead($settings, "Script_Settings", "MakeJDUserAdmin", "0") = 1 Then
				_User ("SET_GROUP", $JDusername, $JDpassword, $JDdomain, "Administrators")
				If IniRead($settings, "Script_Settings", "UseJDUserAsDefaultAdmin", "0") = 1 Then _Shutdown ("REBOOT", "ADD", $JDusername, $JDpassword, $JDdomain, $scriptlocation)
			EndIf
			_Shutdown ("REBOOT", "ADD", $logonuser1, $logonpass1, $machine_name, $scriptlocation)
		Else
			IniWrite($settings, "Script_Settings", "MakeJDUserAdmin", "0")
			IniWrite($settings, "Script_Settings", "UseJDUserAsDefaultAdmin", "0")
			IniWrite($settings, "Script_Settings", "UseJDUserAsCopyProfileUser", "0")
			IniWrite($settings, "Script_Settings", "RemoveJDAdminRights", "0")
		EndIf
	EndIf
	_Progress_Ref ("SHOW")
	
	;*** INSTALL WINDOWS INSTALLER *** - added 6/16/07
	If IniRead($settings, "Script_Settings", "Install_WinInstaller", "0") = 1 And IniRead($settings, "Program_Use_Only", "Installed_WinInstaller", "0") = 0 Then
		GUICtrlSetData($current_action, "Installing Windows Installer")
		_RunNetSupport ($wininstaller_exe, $netuser, $netpass, $netdom)
		IniWrite($settings, "Program_Use_Only", "Installed_WinInstaller", "1")
		_Progress_Ref ("ADD")
		_Shutdown ("REBOOT", "ADD", $logonuser1, $logonpass1, $logondomain1, $scriptlocation)
	EndIf
	_Progress_Ref ("SHOW")
	
	;*** INSTALL MCAFEE ***
	If IniRead($settings, "Script_Settings", "Install_McAfee", "0") = 1 And IniRead($settings, "Program_Use_Only", "Installed_McAfee", "0") = 0 Then
		GUICtrlSetData($current_action, "Installing McAfee")
		_RunNetSupport ($mcafee_exe, $netuser, $netpass, $netdom)
		_RunNetSupport ($mcafee_patch_exe, $netuser, $netpass, $netdom)
		IniWrite($settings, "Program_Use_Only", "Installed_McAfee", "1")
		_Progress_Ref ("ADD")
	EndIf
	
	_Progress_Ref ("SHOW")
	
	;Install Sophos Remote Update
	If IniRead($settings, "Script_Settings", "Install_Sophos", "0") = 1 And IniRead($settings, "Program_Use_Only", "Installed_Sophos", "0") = 0 Then
		GUICtrlSetData($current_action, "Installing Sophos")
		_RunNetSupport ($sophos_exe, $netuser, $netpass, $netdom)
		IniWrite($settings, "Program_Use_Only", "Installed_Sophos", "1")
		_Progress_Ref ("ADD")
	EndIf
	
	_Progress_Ref ("SHOW")
	
	;*** INSTALL VPN SOFTWARE ***
	If IniRead($settings, "Script_Settings", "Install_VPN", "0") = 1 And IniRead($settings, "Program_Use_Only", "Installed_VPN", "0") = 0 Then
		GUICtrlSetData($current_action, "Installing VPN")
		_RunNetSupport ($vpn_exe, $netuser, $netpass, $netdom)
		IniWrite($settings, "Program_Use_Only", "Installed_VPN", "1")
		_Progress_Ref ("ADD")
		$shutdown = "REBOOT"
	EndIf
	
	_Progress_Ref ("SHOW")
	
	;*** INSTALL OFFICE ***
	If IniRead($settings, "Script_Settings", "Install_Office", "0") = 1 And IniRead($settings, "Program_Use_Only", "Installed_Office", "0") = 0 Then
		GUICtrlSetData($current_action, "Installing Office")
		_RunNetSupport ($office_exe, $netuser, $netpass, $netdom)
		IniWrite($settings, "Program_Use_Only", "Installed_Office", "1")
		_Progress_Ref ("ADD")
		$shutdown = "REBOOT"
	EndIf
	
	;Add office toolbar
	If IniRead($settings, "Script_Settings", "AddOfficeToolbar", "0") = 1 And IniRead($settings, "Program_Use_Only", "Added_Office_Toolbar", "0") = 0 Then
		_TaskToolbar ($toolbardir)
		IniWrite($settings, "Program_Use_Only", "Added_Office_Toolbar", "1")
		_Progress_Ref ("ADD")
	EndIf
	_Progress_Ref ("SHOW")
	
	;*** INSTALL DATATEL ***
	If IniRead($settings, "Script_Settings", "Install_Datatel", "0") = 1 And IniRead($settings, "Program_Use_Only", "Installed_Datatel", "0") = 0 Then
		GUICtrlSetData($current_action, "Installing Datatel")
		_RunNetSupport ($datatel_exe, $netuser, $netpass, $netdom)
		IniWrite($settings, "Program_Use_Only", "Installed_Datatel", "1")
		_Progress_Ref ("ADD")
	EndIf
	
	_Progress_Ref ("SHOW")
	
	;Install Deepfreeze seed
	If IniRead($settings, "Script_Settings", "Install_DeepFreeze", "0") = 1 And IniRead($settings, "Program_Use_Only", "Installed_DeepFreeze", "0") = 0 Then
		GUICtrlSetData($current_action, "Installing DeepFreeze Seed")
		_RunNetSupport ($deepfreeze_exe, $netuser, $netpass, $netdom)
		IniWrite($settings, "Program_Use_Only", "Installed_DeepFreeze", "1")
		_Progress_Ref ("ADD")
	EndIf
	
	_Progress_Ref ("SHOW")
	
	;Install Extra
	If IniRead($settings, "Script_Settings", "Run_Extra", "0") = 1 And IniRead($settings, "Program_Use_Only", "Ran_Extra", "0") = 0 Then
		$extraprogram = IniReadSection($settings, "ExtraAutoRuns")
		If Not @error Then
			$extra_lastrun = IniRead($settings, "Program_Use_Only", "extra_lastrun", "1")
			For $i = $extra_lastrun To $extraprogram[0][0]
				GUICtrlSetData($current_action, "Running Extra Install #" & $i & " of " & $extraprogram[0][0])
				_RunNetSupport ($extraprogram[$i][1], $netuser, $netpass, $netdom)
				IniWrite($settings, "Program_Use_Only", "extra_lastrun", $i)
				_Progress_Ref ("ADD")
				_Progress_Ref ("SHOW")
			Next
		EndIf
		IniWrite($settings, "Program_Use_Only", "Ran_Extra", "1")
		_Progress_Ref ("ADD")
		If IniRead($settings, "Program_Use_Only", "ExtraInstallReboot", "0") = 1 Then
			If IniRead($settings, "Script_Settings", "UseJDUserAsDefaultAdmin", "0") = 0 Then
				_Shutdown ("REBOOT", "ADD", $logonuser1, $logonpass1, $logondomain1, $scriptlocation)
			Else
				_Shutdown ("REBOOT", "ADD", $JDusername, $JDpassword, $JDdomain, $scriptlocation)
			EndIf
		EndIf
	EndIf
	
	_Progress_Ref ("SHOW")
	
	;Set Start Menu
	If IniRead($settings, "Script_Settings", "Set_Start_Menu", "0") = 1 And IniRead($settings, "Program_Use_Only", "Set_Start_Menu", "0") = 0 Then
		GUICtrlSetData($current_action, "Setting Start Menu/TaskBar Settings")
		_StartMenu ($settings, $HKUS1521)
		_Taskbar ($settings, $HKUS1521)
		IniWrite($settings, "Program_Use_Only", "Set_Start_Menu", "1")
		_Progress_Ref ("ADD")
		If $shutdown <> "REBOOT" Then $shutdown = "LOGOFF"
	EndIf
	
	_Progress_Ref ("SHOW")
	
	;*** SET VISUAL SETTINGS ***
	If IniRead($settings, "Script_Settings", "Set_Visual_Settings", "0") = 1 And IniRead($settings, "Program_Use_Only", "Set_Visual_Settings", "0") = 0 Then
		GUICtrlSetData($current_action, "Setting Visual Settings")
		_VisualSettings ()
		GUICtrlSetData($current_action, "Setting Desktop Settings")
		_Desktop ($settings, $HKUS1521)
		IniWrite($settings, "Program_Use_Only", "Set_Visual_Settings", "1")
		_Progress_Ref ("ADD")
	EndIf
	
	_Progress_Ref ("SHOW")
	
	;*** Set Folder Options ***
	If IniRead($settings, "Script_Settings", "Set_Folder_Options", "0") = 1 And IniRead($settings, "Program_Use_Only", "Set_Folder_Options", "0") = 0 Then
		GUICtrlSetData($current_action, "Setting Folder Options")
		_FolderOptions ($settings, $HKUS1521)
		IniWrite($settings, "Program_Use_Only", "Set_Folder_Options", "1")
		_Progress_Ref ("ADD")
		If $shutdown <> "REBOOT" Then $shutdown = "LOGOFF"
	EndIf
	
	_Progress_Ref ("SHOW")
	
	If $shutdown <> "" And IniRead($settings, "Script_Settings", "UseJDUserAsDefaultAdmin", "0") = 0 Then
		_Shutdown ($shutdown, "ADD", $logonuser1, $logonpass1, $logondomain1, $scriptlocation)
	Else
		_Shutdown ($shutdown, "ADD", $JDusername, $JDpassword, $JDdomain, $scriptlocation)
	EndIf
	
	;*** WAIT FOR UPDATES/INSTALLS ***
	If IniRead($settings, "Script_Settings", "Wait_Updates", "0") = 1 And IniRead($settings, "Program_Use_Only", "Waited_For_Updates", "0") = 0 Then
		GUICtrlSetData($current_action, "Waiting for Updates")
		_Logon ("ADD", $logonuser1, $logonpass1, $logondomain1, $scriptlocation)
		MsgBox(0, "Waiting", "Install updates or extra software - HIT OK WHEN DONE - This window will start on next boot if you need to restart")
		_Logon ("REMOVE")
		IniWrite($settings, "Program_Use_Only", "Waited_For_Updates", "1")
		_Progress_Ref ("ADD")
	EndIf

	_Progress_Ref ("SHOW")
	
	;Turn Off Automatic Updates - Added 11/07/2007
	If IniRead($settings, "Script_Settings", "AutoUpdate", "0") = 1 And IniRead($settings, "Program_Use_Only", "AutoUpdate", "0") = 0 Then
		GUICtrlSetData($current_action, "Turning off Automatic Updates")
		RegWrite("HKLM\SOFTWARE\Policies\Microsoft\Windows\WindowsUpdate\AU", "RebootRelaunchTimeoutEnabled", "REG_DWORD", "00000000")
		RegWrite("HKLM\SOFTWARE\Policies\Microsoft\Windows\WindowsUpdate\AU", "NoAutoRebootWithLoggedOnUsers", "REG_DWORD", "00000001");Turn off reboot prompt when users are logged on
		RegWrite("HKLM\SOFTWARE\Policies\Microsoft\Windows\WindowsUpdate\AU", "NoAutoUpdate", "REG_DWORD", "00000001");Disable Automatic Updates
		IniWrite($settings, "Program_Use_Only", "AutoUpdate", "1")
		_Progress_Ref ("ADD")
	EndIf
	
	_Progress_Ref ("SHOW")
	
	;Delete IconCache.db - Added 11/07/2007
	If IniRead($settings, "Script_Settings", "DeleteIconCache", "0") = 1 And IniRead($settings, "Program_Use_Only", "DeleteIconCache", "0") = 0 Then
		GUICtrlSetData($current_action, "Deleting IconCache.db")
		FileDelete(@UserProfileDir & '\Local Settings\Application Data\IconCache.db')
		IniWrite($settings, "Program_Use_Only", "DeleteIconCache", "1")
		_Progress_Ref ("ADD")
	EndIf
	
	_Progress_Ref ("SHOW")
	
	;*** MAKE SYSPREP USER - RESTART FOR COPY PROFILE ***
	If IniRead($settings, "Script_Settings", "Copy_Profile", "0") = 1 And IniRead($settings, "Program_Use_Only", "Copy_Profile_Step1", "0") = 0 Then
		If IniRead($settings, "Program_Use_Only", "CreateCopyProfileUser", "1") = 1 And IniRead($settings, "Script_Settings", "UseJDUserAsCopyProfileUser", "0") = 0 Then
			GUICtrlSetData($current_action, "Creating Copy Profile User")
			_User ("ADD", $logonuser2, $logonpass2, $logondomain2, "Administrators")
		EndIf
		IniWrite($settings, "Program_Use_Only", "Copy_Profile_Step1", "1")
		GUICtrlSetData($current_action, "Rebooting to copy profile")
		If IniRead($settings, "Script_Settings", "UseJDUserAsCopyProfileUser", 0) = 0 Then
			_Shutdown ("REBOOT", "ADD", $logonuser2, $logonpass2, $logondomain2, $scriptlocation)
		Else
			_Shutdown ("REBOOT", "ADD", $JDusername, $JDpassword, $JDdomain, $scriptlocation)
		EndIf
	EndIf
	
	
	;*** COPY PROFILE ***
	If IniRead($settings, "Script_Settings", "Copy_Profile", "0") = 1 And IniRead($settings, "Program_Use_Only", "Copy_Profile_Step2", "0") = 0 Then
		GUICtrlSetData($current_action, "Copying Profile")
		_Profile ("COPY", $logonuser1)
		IniWrite($settings, "Program_Use_Only", "Copy_Profile_Step2", "1")
		_Shutdown ("REBOOT", "ADD", $logonuser1, $logonpass1, $logondomain1, $scriptlocation) ;logging back on as normal user so join domain user profile and admin rights can de deleted
	EndIf
	
	;*** Remove sysprep user/profile ***
	If IniRead($settings, "Script_Settings", "Copy_Profile", "0") = 1 And IniRead($settings, "Program_Use_Only", "Copy_Profile_Step3", "0") = 0 Then
		If IniRead($settings, "Program_Use_Only", "DeleteCopyProfileUser", "1") = 1 And IniRead($settings, "Script_Settings", "UseJDUserAsCopyProfileUser", "0") = 0 Then
			GUICtrlSetData($current_action, "Removing Copy Profile User")
			_User ("REMOVE", $logonuser2, "", $logondomain2)
		EndIf
		IniWrite($settings, "Program_Use_Only", "Copy_Profile_Step3", "1")
		_Progress_Ref ("ADD")
	EndIf
	
	_Progress_Ref ("SHOW")
	
	;cleanup join domain user profile and remove from adminisrators group(if specified)
	If IniRead($settings, "Script_Settings", "MakeJDUserAdmin", "0") = 1 Then
		If IniRead($settings, "Script_Settings", "RemoveJDAdminRights", "0") = 1 Then _User ("REMOVE_GROUP", $JDusername, "", $JDdomain, "Administrators")
		If IniRead($settings, "Script_Settings", "UseJDUserAsDefaultAdmin", "0") = 1 Then _Profile ("REMOVE", $JDusername, $JDdomain)
		If IniRead($settings, "Script_Settings", "UseJDUserAsCopyProfileUser", "0") = 1 And IniRead($settings, "Script_Settings", "Copy_Profile", "0") = 1 Then _Profile ("REMOVE", $JDusername, $JDdomain)
	EndIf
	
	;*** CLEAN SMS ***
	If IniRead($settings, "Script_Settings", "Clean_SMS", "0") = 1 And IniRead($settings, "Program_Use_Only", "Cleaned_SMS", "0") = 0 Then
		GUICtrlSetData($current_action, "Cleaning SMS")
		_RunNetSupport ($cleansms_exe, $netuser, $netpass, $netdom)
		IniWrite($settings, "Program_Use_Only", "Cleaned_SMS", "1")
		_Progress_Ref ("ADD")
	EndIf
	
	_Progress_Ref ("SHOW")
	
	;*** REMOVE McAfee GUID ***
	If IniRead($settings, "Script_Settings", "Remove_McAfee_GUID", "0") = 1 And IniRead($settings, "Program_Use_Only", "Removed_McAfee_GUID", "0") = 0 Then
		GUICtrlSetData($current_action, "Removing McAfee GUID")
		RunWait("net stop McAfeeFramework")
		RegDelete("HKEY_LOCAL_MACHINE\SOFTWARE\Network Associates\ePolicy Orchestrator\Agent", "AgentGUID")
		IniWrite($settings, "Program_Use_Only", "Removed_McAfee_GUID", "1")
		_Progress_Ref ("ADD")
	EndIf
	
	_Progress_Ref ("SHOW")
	
	;*** DEFRAGMENT ***
	If IniRead($settings, "Script_Settings", "Defrag", "0") = 1 And IniRead($settings, "Program_Use_Only", "Defraged", "0") = 0 Then
		GUICtrlSetData($current_action, "Defraging Local Disk")
		_Defrag ()
		IniWrite($settings, "Program_Use_Only", "Defraged", "1")
		_Progress_Ref ("ADD")
	EndIf
	
	_Progress_Ref ("SHOW")
	
	;*** SYSPREP ***
	If IniRead($settings, "Script_Settings", "Run_Sysprep", "0") = 1 And IniRead($settings, "Program_Use_Only", "Ran_Sysprep", "0") = 0 Then
		GUICtrlSetData($current_action, "Running Sysprep")
		If @OSVersion = "WIN_XP" Then
			DirCopy($workingdir & "sysprep\WinXP\sysprep", "c:\sysprep", 1)
			Run("c:\sysprep\sysprep.exe")
		EndIf
		If @OSVersion = "WIN_2000" Then
			DirCopy($workingdir & "sysprep\Win2K\sysprep", "c:\sysprep", 1)
			Run("c:\sysprep\sysprep.exe")
		EndIf
		If @OSVersion = "WIN_VISTA" Then
			Run("C:\Windows\System32\Sysprep\Sysprep.exe")
		EndIf
		IniWrite($settings, "Program_Use_Only", "Ran_Sysprep", "1")
		_Progress_Ref ("ADD")
	EndIf
	
	_Progress_Ref ("SHOW")
	;Add _no_gui.exe to startup
	If IniRead($settings, "Script_Settings", "addprepsystostartup", "0") = 1 And IniRead($settings, "Program_Use_Only", "addedprepsystostartup_Step1", "0") = 0 Then
		GUICtrlSetData($current_action, "Adding _no_gui.exe to statup")
		RegWrite('HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Run', 'Continue_Sysprep', "REG_SZ", '"' & @ScriptFullPath & '"')
		IniWrite($settings, "Program_Use_Only", "addedprepsystostartup_Step1", "1")
		_Progress_Ref ("ADD")
		GUICtrlSetData($current_action, "Done - PrepSys - By:Andrew Calcutt")
		_Progress_Ref ("SHOW")
		Sleep(3000)
		Exit
	EndIf
	
	;Add PrepSys To Startup
	If IniRead($settings, "Script_Settings", "addprepsystostartup", "0") = 1 And IniRead($settings, "Program_Use_Only", "addedprepsystostartup_Step2", "0") = 0 Then
		GUICtrlSetData($current_action, "Running Prepsys with specified INI")
		_RunNetSupport ('"' & $PrepsysLocation & '"', $netuser, $netpass, $netdom, "0")
		IniWrite($settings, "Program_Use_Only", "addedprepsystostartup_Step2", "1")
	EndIf
	
	_Progress_Ref ("SHOW")
	
	ExitLoop
WEnd
_DeleteINI ();Delete settings.ini if done
GUICtrlSetData($current_action, "Done - PrepSys - By:Andrew Calcutt")
_Progress_Ref ("SHOW")
Sleep(3000)
GUIDelete();end progress window

FileDelete(@HomeDrive & "\defaultimg.bmp");delete temp desktop image
_SelfDelete();delete current exe
Exit

Func _SelfDelete($iDelay = 0)
	If StringInStr(@ScriptName, ".au3") = 0 Then
		Local $sCmdFile
		FileDelete(@TempDir & "\scratch.bat")
		$sCmdFile = 'ping -n ' & $iDelay & '127.0.0.1 > nul' & @CRLF _
				 & ':loop' & @CRLF _
				 & 'del "' & @ScriptFullPath & '"' & @CRLF _
				 & 'if exist "' & @ScriptFullPath & '" goto loop' & @CRLF _
				 & 'del ' & @TempDir & '\scratch.bat'
		FileWrite(@TempDir & "\scratch.bat", $sCmdFile)
		Run(@TempDir & "\scratch.bat", @TempDir, @SW_HIDE)
	EndIf
EndFunc   ;==>_SelfDelete
